<?php 
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    class Lista {
        private $db;
        private $id;
        private $nome;
        private $descrizione;
        private $spazioOccupato;
        private $icona;
        private $tipoVisualizzazione;
        
        public function __construct($db, $id, $nome="", $descrizione="", $spazioOccupato="", $icona="", $tipoVisualizzazione="") {
            $this->db   = $db;
            $this->id   = $id;
            $this->nome = $nome;
            $this->descrizione    = $descrizione;
            $this->spazioOccupato = $spazioOccupato;
            $this->icona          = $icona;
            $this->tipoVisualizzazione = $tipoVisualizzazione;
        }

        function crea() {
            $query    = "INSERT INTO geec_liste VALUES(NULL,'$this->nome','$this->spazioOccupato','$this->descrizione','$this->icona','$this->tipoVisualizzazione')";
            $this->id = $this->db->eseguiQueryCreazione($query);
            return $this->id;
        }
        
        function modifica() {
            $query    = "UPDATE geec_liste SET nome='$this->nome', spazioOccupato='$this->spazioOccupato', descrizione='$this->descrizione', icona='$this->icona', tipoVisualizzazione='$this->tipoVisualizzazione' WHERE id=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function elimina() {
            $this->db->eseguiQueryCancellazione("geec_liste",$this->id);
            
            $queryEliminaElementiLista = "DELETE FROM geec_elementiLista WHERE idLista = $this->id";
            $this->db->eseguiQueryScrittura($queryEliminaElementiLista);
            
            // elimina le occorrenze in cui la form è presente, l'id di questo componente è 26
            eliminaOccorrenzeComponente($this->db,$this->id,26);
        }
        
        function duplica() {
            $query    = "INSERT INTO geec_liste VALUES(NULL,'Copia di $this->nome')";
            $idNuovaForm = $this->db->eseguiQueryCreazione($query);
            
            $query       = "SELECT * FROM geec_elementiLista WHERE idLista='$this->id'";
            $risElementi = $this->db->eseguiQueryLettura($query);
            while($elementoDaCopiare = $risElementi->fetch_assoc()) {
                $query = "INSERT INTO `geec_elementiLista` (`id`, `idLista`, `posizione`, `nome`, `etichetta`, `valore`, `placeholder`, `tipo`, `opzioni`, `obbligatorio`) "
                    . "VALUES (NULL, '$idNuovaForm', '{$elementoDaCopiare["posizione"]}', '{$elementoDaCopiare["nome"]}', '{$elementoDaCopiare["etichetta"]}', '{$elementoDaCopiare["valore"]}', '{$elementoDaCopiare["placeholder"]}', '{$elementoDaCopiare["tipo"]}', '{$elementoDaCopiare["opzioni"]}', '{$elementoDaCopiare["obbligatorio"]}')";
                $this->db->eseguiQueryCreazione($query);
            }
            return $idNuovaForm;
        }
        
        function caricaDatiDalDatabase() {
            $datiLista   = $this->db->leggiSingolaRiga("geec_liste",$this->id);
            $this->nome = $datiLista["nome"];
            $this->descrizione    = $datiLista["descrizione"];
            $this->spazioOccupato = $datiLista["spazioOccupato"];
            $this->icona          = $datiLista["icona"];
            $this->tipoVisualizzazione = $datiLista["tipoVisualizzazione"];
        }
        
        function creaElemento($nome,$descrizione) {
            $queryPosizione = "SELECT * FROM geec_elementiLista WHERE idLista=$this->id ORDER BY posizione DESC LIMIT 1";
            $risPosizione   = $this->db->eseguiQueryLettura($queryPosizione);
            $datiElemento   = $risPosizione->fetch_assoc();
            $posizione = ($risPosizione->num_rows>0) ? $datiElemento["posizione"] + 1 : 1;
            
            $query = "INSERT INTO `geec_elementiLista` (`id`, `idLista`, `classeElemento`, `nome`, `descrizione`,`posizione`) "
                    . "VALUES (NULL, '$this->id', '', '$nome', '$descrizione','$posizione')";
            $idElemento = $this->db->eseguiQueryCreazione($query);
            return $idElemento;
        }
        
        function stampaElementi() {
            
            $query = "SELECT * FROM geec_elementiLista WHERE idLista = {$this->id} ORDER BY posizione ASC";
            $risultatoQuery = $this->db->eseguiQueryLettura($query);
            while($elemento = $risultatoQuery->fetch_assoc()) {
                $posizionePrecedente = ($elemento["posizione"]<=1) ? 1 : $elemento["posizione"] - 1;
                $posizioneSuccesiva  = $elemento["posizione"] +1;
                
                $nomeEscape = filter_var($elemento["nome"],FILTER_SANITIZE_ADD_SLASHES);
            ?>
                <div id="elementoComponente<?php echo $elemento["id"] ?>" class="card-body mb-3 py-1 px-2 bg-light border rounded d-sm-flex justify-content-between align-items-center text-center">
                    <div class="d-flex">
                        <div class="mb-1 mb-sm-0 text-muted w-50 text-left w-100">
                            <p class="mb-0"><em><a href="creaElemento.php?id=<?php echo $elemento["id"] ?>"><strong><?php echo $elemento["nome"] ?></strong></a></em></p>
                        </div>
                    </div>
                    <div class="azioni d-flex align-items-center justify-content-end">
                        <form class="d-inline-flex mr-sm-1">
                            <div class="input-group input-group-sm d-flex align-items-center">
                                <small class="text-muted mr-2">Pos.</small>
                                <input type="number" id="nuovaPosizioneElemento<?php echo $elemento["id"]; ?>" class="form-control" aria-label="posizione" min="1" value="<?php echo $elemento["posizione"] ?>">
                                <div class="input-group-append">
                                    <button class="btn btn-primary" type="button" onclick="spostaElementoInput(<?php echo $elemento["id"]; ?>)">Salva</button>
                                </div>
                            </div>
                        </form>
                        <div class="btn-group" role="group" aria-label="Basic example">
                            <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="" onclick="spostaElemento(<?php echo $elemento["id"]; ?>,<?php echo $posizionePrecedente ?>)" data-original-title="Sposta su"><i class="fas fa-arrow-up"></i></button>
                            <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="" onclick="spostaElemento(<?php echo $elemento["id"]; ?>,<?php echo $posizioneSuccesiva ?>)" data-original-title="Sposta giu"><i class="fas fa-arrow-down"></i></button>
                            <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="" onclick="location.href='creaElemento.php?id=<?php echo $elemento["id"]; ?>';" data-original-title="Configura elemento"><i class="fas fa-cog"></i></button>
                            <button type="button" class="btn btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="" onclick="eliminaElemento(<?php echo $elemento["id"]; ?>,'<?php echo $nomeEscape; ?>')" data-original-title="Elimina"><i class="far fa-trash-alt"></i></button>
                        </div>
                    </div>
                </div>
            <?php
            }
        }
        
        function modificaElemento($id,$nome,$descrizione,$classeELemento) {
            $query = "UPDATE geec_elementiLista SET nome='$nome', descrizione='$descrizione', classeELemento='$classeELemento' WHERE id=$id";
            $this->db->eseguiQueryCreazione($query);
        }
        
        function duplicaElemento($id,$prefisso = "Copia di ") {
            $this->db->eseguiQueryScrittura("CREATE TEMPORARY TABLE tabella_temporanea SELECT * FROM geec_elementiLista WHERE id=$id");
            $this->db->eseguiQueryScrittura("UPDATE tabella_temporanea SET id = 0;");
            $this->db->eseguiQueryScrittura("INSERT INTO geec_elementiLista SELECT * FROM tabella_temporanea;");
            $idContenutoDuplicato = $this->db->idUltimoElemento();
            
            $this->db->eseguiQueryScrittura("UPDATE geec_elementiLista SET nome = CONCAT('$prefisso', ' ', nome) WHERE id=$idContenutoDuplicato");
            return $idContenutoDuplicato;
        }
        
        function cambiaImmagineElemento($idElemento,$percorsoFoto) {
            $query = "UPDATE `geec_elementiLista` SET  percorsoImmagine ='$percorsoFoto' WHERE id=$idElemento";
            $this->id = $this->db->eseguiQueryCreazione($query);
        }
        
        function spostaElemento($idElemento,$posizione) {
            $queryPosizione = "SELECT * FROM geec_elementiLista WHERE idLista=$this->id AND id != $idElemento ORDER BY posizione ASC";
            $risElementi    = $this->db->eseguiQueryLettura($queryPosizione);
            
            $posizioneCorrente = 1;
            while($elementoCorrente = $risElementi->fetch_assoc()) {
                if($posizione==$posizioneCorrente) {
                    $posizioneCorrente++;
                }
                $queryPosizione = "UPDATE geec_elementiLista SET posizione=$posizioneCorrente WHERE id = {$elementoCorrente["id"]} ";
                $this->db->eseguiQueryScrittura($queryPosizione);
                $posizioneCorrente ++;
            }
            $queryPosizioneElementoPrincipale = "UPDATE geec_elementiLista SET posizione=$posizione WHERE id = $idElemento ";
            $this->db->eseguiQueryScrittura($queryPosizioneElementoPrincipale);
        }
        
        function eliminaElemento($idElemento) {
            $this->db->eseguiQueryCancellazione("geec_elementiLista",$idElemento);
        }
        
        // getter & setter
        public function getDb() {
            return $this->db;
        }

        public function getId() {
            return $this->id;
        }

        public function getNome() {
            return $this->nome;
        }

        public function getDescrizione() {
            return $this->descrizione;
        }

        public function getSpazioOccupato() {
            return $this->spazioOccupato;
        }

        public function getIcona() {
            return $this->icona;
        }

        public function getTipoVisualizzazione() {
            return $this->tipoVisualizzazione;
        }

        public function setDb($db) {
            $this->db = $db;
        }

        public function setId($id) {
            $this->id = $id;
        }

        public function setNome($nome) {
            $this->nome = $nome;
        }

        public function setDescrizione($descrizione) {
            $this->descrizione = $descrizione;
        }

        public function setSpazioOccupato($spazioOccupato) {
            $this->spazioOccupato = $spazioOccupato;
        }

        public function setIcona($icona) {
            $this->icona = $icona;
        }

        public function setTipoVisualizzazione($tipoVisualizzazione) {
            $this->tipoVisualizzazione = $tipoVisualizzazione;
        }
        
    }